﻿using System;
using System.Linq;
using System.Collections.Generic;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml.Linq;
using System.ComponentModel;
using System.Drawing.Design;

namespace TextBoxInfoControl
{
    /// <summary>
    /// Summary description for ServerControl1
    /// </summary>
    public class TextBoxInfo : ScriptControl
    {
        private const string TextBoxId = "DataEntryTextBox";
        private const string ImageId = "InformationImageButton";
        
        public TextBoxInfo()
        {
        }

        public string Text { get; set; }
        
        public string InformationText { get; set; }
        [Editor("System.Web.UI.Design.ImageUrlEditor, System.Design, Version=2.0.0.0, Culture=neutral, PublicKeyToken=b03f5f7f11d50a3a", typeof(UITypeEditor)),UrlProperty] 
        public string ImageUrl { get; set; }

        protected override HtmlTextWriterTag TagKey
        {
            get
            {
                return HtmlTextWriterTag.Table;
            }
        }
        
        protected override void RenderContents(HtmlTextWriter writer)
        {
            writer.RenderBeginTag(HtmlTextWriterTag.Tr);
            
            writer.RenderBeginTag(HtmlTextWriterTag.Td);
            writer.AddAttribute(HtmlTextWriterAttribute.Id, TextBoxId);
            writer.AddAttribute(HtmlTextWriterAttribute.Type, "text");
            writer.AddAttribute(HtmlTextWriterAttribute.Value, Text);
            writer.RenderBeginTag(HtmlTextWriterTag.Input);
            writer.RenderEndTag();
            writer.RenderEndTag();
            
            writer.RenderBeginTag(HtmlTextWriterTag.Td);
            writer.AddAttribute(HtmlTextWriterAttribute.Id, ImageId);
            writer.AddAttribute(HtmlTextWriterAttribute.Src, ImageUrl);
            writer.RenderBeginTag(HtmlTextWriterTag.Img);
            writer.RenderEndTag();
            writer.RenderEndTag();
            
            writer.RenderEndTag();
        }

        protected override IEnumerable<ScriptDescriptor>
                GetScriptDescriptors()
        {
            ScriptControlDescriptor descriptor = new ScriptControlDescriptor("TextBoxInfoControl.TextBoxInfo", this.ClientID);
            descriptor.AddElementProperty("textBoxElement", TextBoxId);
            descriptor.AddElementProperty("imageElement", ImageId);
            descriptor.AddProperty("informationText", InformationText);
            yield return descriptor;
        }

        // generuje referencję do skryptu
        protected override IEnumerable<ScriptReference>
                GetScriptReferences()
        {
            yield return new ScriptReference("TextBoxInfoControl.TextBoxInfo.js", this.GetType().Assembly.FullName);
        }
    }
}